#version 400 compatibility

/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

/*DRAWBUFFERS:023*/
layout(location = 0) out vec4 sceneColor;
layout(location = 1) out vec4 gData1;
layout(location = 2) out vec4 out3;

#include "/lib/head.glsl"
#include "/lib/util/encoders.glsl"
#include "/lib/util/colorspace.glsl"

in vec2 coord;

flat in mat2x3 lightColor;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;

uniform sampler2D depthtex0;

uniform float aspectRatio;
uniform float far, near;
uniform float sunAngle;

uniform vec2 taaOffset;
uniform vec2 viewSize;

uniform vec3 lightvec, lightvecView;

uniform mat4 gbufferModelView, gbufferModelViewInverse;
uniform mat4 gbufferProjection, gbufferProjectionInverse;

/* ------ includes ------ */
#include "/lib/util/transforms.glsl"

#define FUTIL_LINDEPTH
#define FUTIL_MAT16
#define FUTIL_LIGHTMAP
#include "/lib/fUtil.glsl"

#define noSPEC
#define noBRDF
#include "/lib/frag/labPBR.glsl"

/* ------ metal albedo encoding ------ */

float bayer2e(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}
#define bayer4e(a)   (bayer2e( .5*(a))*.25+bayer2e(a))

#define m vec3(31,63,31)
float encode3x8(vec3 a){
    float dither = bayer4e(gl_FragCoord.xy);
    a += (dither-.5) / m;
    a = saturate(a);
    ivec3 b = ivec3(a*m);
    return float( b.r|(b.g<<5)|(b.b<<11) ) / 65535.;
}
#undef m

vec4 textureBilateral(sampler2D tex, sampler2D depth, const int lod, float fdepth) {
    vec4 data   = vec4(0.0);
    float sum   = 0.0;
    ivec2 posD  = ivec2(coord*viewSize);
    ivec2 posT  = ivec2(coord*viewSize*rcp(float(lod)));
    vec3 zmult  = vec3((far*near)*2.0, far+near, far-near);
        fdepth  = depthLinear(fdepth);
    
    for (int i = -1; i<2; i++) {
        for (int j = -1; j<2; j++) {
            ivec2 tcDepth = posD + ivec2(i, j)*lod;
            float dsample = depthLinear(texelFetch(depth, tcDepth, 0).x);
            float w     = abs(dsample-fdepth)*zmult.x<1.0 ? 1.0 : 1e-5;
            ivec2 ct    = posT + ivec2(i, j);
            data       += texelFetch(tex, ct, 0)*w;
            sum        += w;
        }
    }
    data *= rcp(sum);

    return data;
}

void main() {
        sceneColor  = stex(colortex0);
    float sceneDepth = stex(depthtex0).x;
    vec4 tex2       = stex(colortex2);

    vec3 albedo     = sceneColor.rgb;

    if (landMask(sceneDepth)) {
        vec4 tex1       = stex(colortex1);
        vec2 sceneLmap  = decode2x8(tex1.z);

        vec4 tex2       = stex(colortex2);
        int matID       = decodeMatID16(tex2.x);

        vec4 specularData = vec4(decode2x8(tex2.y), decode2x8(tex2.z));

        materialLAB matLAB = decodeSpecularTexture(specularData);

        #if DEBUG_VIEW==1
        sceneColor.rgb    = vec3(1.0);
        #endif

        #ifdef lightmapSmoothingEnabled
        vec3 tex3       = stex(colortex3).xyz;
            sceneLmap   = tex3.xy;
            sceneColor.a = tex3.z;
        #endif

        float ao        = cube(sceneColor.a)*0.94+0.06;

        #ifdef ambientOcclusionEnabled
            vec4 upscale3 = textureBilateral(colortex3, depthtex0, 2, sceneDepth);
                ao     *= upscale3.w;
        #endif

        /* ------ lighting ------ */

        vec2 lmap       = sceneLmap;
        lmap.y          = cube(lmap.y);

        vec3 indirectLight = lightColor[0];
            indirectLight += vec3(0.5, 0.7, 1.0)*0.01*minLightLuma;
            indirectLight *= ao;

        vec3 result     = indirectLight;
            result     += getBlocklightMap(lightColor[1], lmap.x)*ao;
        
        #ifdef labEmissionEnabled
            result     += matLAB.emission * v3avg(lightColor[1]);
        #endif

        if (matID == 5) {
            vec3 emitterCol     = mix(lightColor[1], vec3(v3avg(lightColor[1])), emitterRecoloring);
                emitterCol     *= cubeSmooth(saturate(v3avg(sceneColor.rgb) * 1.5));
            result += emitterCol;
        }

        sceneColor.rgb *= result;

        #if DEBUG_VIEW==2
        sceneColor.rgb    = ao * lightColor[0] * 2.0;
        #endif
    }

    tex2.z  = encode3x8(sqrt(saturate(albedo.rgb)));

    sceneColor  = makeDrawbuffer(sceneColor);
    gData1      = clamp16F(tex2);
    out3        = vec4(0.0);
}